document.getElementById("bookingForm").addEventListener("submit", function(e) {
  e.preventDefault();
  alert("Your booking has been submitted!");
});

document.getElementById('bookingForm').addEventListener('submit', function (e) {
  e.preventDefault();

  const parkingDate = document.getElementById('parkingDate').value;
  const parkingTime = document.getElementById('parkingTime').value;
  const collectDate = document.getElementById('collectDate').value;
  const collectTime = document.getElementById('collectTime').value;

  const from = new Date(`${parkingDate}T${parkingTime}`);
  const to = new Date(`${collectDate}T${collectTime}`);

  const diffInMs = to - from;
  const diffInDays = Math.ceil(diffInMs / (1000 * 60 * 60 * 24));

  let price = 0;
  if (diffInDays <= 0) {
    price = 40;
  } else if (diffInDays === 1) {
    price = 40;
  } else if (diffInDays <= 9) {
    price = 40 + (diffInDays - 1) * 5;
  } else {
    price = 40 + 8 * 5 + (diffInDays - 9) * 4;
  }

  // Pass price via query string
  const queryParams = new URLSearchParams({
    from: from.toLocaleDateString(),
    to: to.toLocaleDateString(),
    days: diffInDays,
    price: price
  });

  window.location.href = `pricing.html?${queryParams.toString()}`;
});
