<?php
// Enable error reporting (disable in production)
ini_set('display_errors', 1);
error_reporting(E_ALL);

// Database connection settings
$servername = "localhost:3306";
$username = "stanosby_app";
$password = "mD5@NtPdmD5@NtPd";
$dbname = "stanosby_app";


// Include PHPMailer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;
require 'vendor/autoload.php'; // Ensure composer dependencies are installed

// Create DB connection
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    die("❌ Database connection failed: " . $conn->connect_error);
}

// Auto-generate next BookingRef (e.g., CP-1, CP-2, ...)
$bookingRef = "CP-1";
$sqlRef = "SELECT BookingRef FROM vehicle_info WHERE BookingRef LIKE 'CP-%' ORDER BY id DESC LIMIT 1";
$result = $conn->query($sqlRef);
if ($result && $row = $result->fetch_assoc()) {
    $lastRef = $row['BookingRef'];
    $parts = explode("-", $lastRef);
    if (count($parts) === 2 && is_numeric($parts[1])) {
        $bookingRef = "CP-" . (intval($parts[1]) + 1);
    }
}

// Get POST data
$productCode     = $_POST['ProductCode']      ?? '';
$customer        = $_POST['Customer']         ?? '';
$email           = $_POST['Email']            ?? '';
$entryDate       = $_POST['EntryDate']        ?? '';
$entryTime       = $_POST['EntryTime']        ?? '';
$returnDate      = $_POST['ReturnDate']       ?? '';
$returnTime      = $_POST['ReturnTime']       ?? '';
$vehicleMake     = $_POST['VehicleMake']      ?? '';
$registrationNo  = $_POST['RegistrationNo']   ?? '';
$productType     = $_POST['ProductType']      ?? '';
$passenger       = intval($_POST['Passenger'] ?? 0);
$airportTerminal = $_POST['AirportTerminal']  ?? '';
$inFlightNumber  = $_POST['InFlightNumber']   ?? '';
$outFlightNumber = $_POST['OutFlightNumber']  ?? '';
$price           = floatval($_POST['Price']   ?? 0.0);
$emailReceivedAt = date('Y-m-d H:i:s');

// Validate critical fields
if (!$customer || !$entryDate || !$vehicleMake || !$registrationNo) {
    die("❌ Missing required fields.");
}

// Insert into DB
$sql = "INSERT INTO vehicle_info (
    ProductCode, BookingRef, Customer, Email, EntryDate, EntryTime, ReturnDate, ReturnTime,
    VehicleMake, RegistrationNo, ProductType, Passenger, AirportTerminal,
    InFlightNumber, OutFlightNumber, Price, EmailReceivedAt
) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";

$stmt = $conn->prepare($sql);
if (!$stmt) {
    die("❌ Prepare failed: " . $conn->error);
}

$stmt->bind_param("ssssssssssssssdds",
    $productCode, $bookingRef, $customer, $email, $entryDate, $entryTime,
    $returnDate, $returnTime, $vehicleMake, $registrationNo,
    $productType, $passenger, $airportTerminal, $inFlightNumber,
    $outFlightNumber, $price, $emailReceivedAt
);

// Save to DB and send email
if ($stmt->execute()) {
    try {
        $mail = new PHPMailer(true);
        $mail->isSMTP();
        $mail->Host       = 'stanstedairportcheapparking.co.uk';
        $mail->SMTPAuth   = true;
        $mail->Username   = 'booking@stanstedairportcheapparking.co.uk';
        $mail->Password   = 'mD5@NtPdmD5@NtPd';
        $mail->SMTPSecure = 'ssl';
        $mail->Port       = 465;

        $mail->setFrom('booking@stanstedairportcheapparking.co.uk', 'Stansted Airport Parking');
        $mail->addAddress($email); // Customer
        $mail->addAddress('youradmin@email.com'); // Admin (optional)

        $mail->Subject = "Booking Confirmation - Ref $bookingRef";
        $mail->Body    = "Hello $customer,\n\nYour booking has been confirmed:\n\n"
            . "Booking Ref: $bookingRef\n"
            . "Entry: $entryDate $entryTime\n"
            . "Return: $returnDate $returnTime\n"
            . "Vehicle: $vehicleMake ($registrationNo)\n"
            . "Product: $productType\n"
            . "Passengers: $passenger\n"
            . "Terminal: $airportTerminal\n"
            . "Price: £$price\n\n"
            . "Thank you for booking with Stansted Airport Parking.";

        $mail->send();
    } catch (Exception $e) {
        error_log("❌ Email not sent: {$mail->ErrorInfo}");
    }

    // Redirect after success
    header("Location: thank_you.html");
    exit;
} else {
    echo "❌ Booking failed: " . $stmt->error;
}

$stmt->close();
$conn->close();
?>
