<?php
// File: fetch_and_insert_email.php

ini_set('display_errors', 1);
error_reporting(E_ALL);
ob_start();

// ------------------------
// Database Configuration
// ------------------------
$host = "localhost:3306";
$user = "stanosby_app";
$password = "mD5@NtPdmD5@NtPd";
$dbname = "stanosby_app";

$emailHost = "{stanstedairportcheapparking.co.uk:993/imap/ssl}";
$emailUser = "booking@stanstedairportcheapparking.co.uk";
$emailPass = "mD5@NtPdmD5@NtPd";

$folders = ["INBOX", "Junk", "Spam"];
$emails = [];

foreach ($folders as $folder) {
    $mbox = imap_open($emailHost . $folder, $emailUser, $emailPass);
    if (!$mbox) continue;
    $newEmails = imap_search($mbox, 'UNSEEN');
    if ($newEmails) {
        $emails = array_merge($emails, array_map(fn($id) => ['folder' => $folder, 'id' => $id], $newEmails));
    }
    imap_close($mbox);
}

if (empty($emails)) {
    echo "📭 No unseen emails found with CSV attachments.";
    exit;
}

foreach ($emails as $emailInfo) {
    $folder = $emailInfo['folder'];
    $email_number = $emailInfo['id'];
    $inbox = imap_open($emailHost . $folder, $emailUser, $emailPass);
    $structure = imap_fetchstructure($inbox, $email_number);
    $header = imap_headerinfo($inbox, $email_number);
    $emailReceivedDate = date("Y-m-d H:i:s", strtotime($header->date));

    if (!isset($structure->parts)) continue;

    foreach ($structure->parts as $partNum => $part) {
        if (!empty($part->ifparameters)) {
            foreach ($part->parameters as $param) {
                if (strtolower($param->attribute) === "name" && str_ends_with(strtolower($param->value), ".csv")) {
                    $body = imap_fetchbody($inbox, $email_number, $partNum + 1);
                    $body = $part->encoding == 3 ? base64_decode($body) : ($part->encoding == 4 ? quoted_printable_decode($body) : $body);

                    $tmpFile = tempnam(sys_get_temp_dir(), 'booking_');
                    file_put_contents($tmpFile, $body);
                    if (($handle = fopen($tmpFile, 'r')) !== false) {
                        $firstLine = fgets($handle);
                        $delimiter = (substr_count($firstLine, ",") > substr_count($firstLine, "\t")) ? "," : "\t";
                        rewind($handle);
                        $headers = array_map('strtolower', array_map('trim', str_getcsv(fgets($handle), $delimiter)));
                        $conn = new mysqli($host, $user, $password, $dbname);
                        if ($conn->connect_error) continue;

                        while (($row = fgetcsv($handle, 1000, $delimiter)) !== false) {
                            if (count($row) !== count($headers)) continue;
                            $csv = array_combine($headers, $row);
                            if (!$csv) continue;

                            $BookingRef = $conn->real_escape_string($csv["bookingid"] ?? $csv["reference number"] ?? '');
                            if (!$BookingRef) continue;

                            if (isset($csv["departuredate"]) && isset($csv["returndate"])) {
                                $DepartureDate = DateTime::createFromFormat('d/m/Y', $csv["departuredate"]);
                                $ReturnDate = DateTime::createFromFormat('d/m/Y', $csv["returndate"]);
                                $dropTime = $csv["droptime"];
                                $returnTime = $csv["returntime"];
                                $Customer = $csv["customerfirstname"] . " " . $csv["customerlastname"] . " (" . $csv["customertelephone"] . ")";
                                $Price = (float) $csv["amount"];
                                $ProductType = $csv["productname"];
                                $Passenger = 1;
                                $VehicleMake = $csv["model"] ?? '';
                                $Registration = $csv["registration"] ?? '';
                                $AirportTerminal = $csv["departure_terminal"] ?? 'TBC';
                                $InFlight = $csv["flightno"] ?? 'TBC';
                                $OutFlight = $csv["return_terminal"] ?? 'TBC';
                            } elseif (isset($csv["arrival date/time"]) && isset($csv["return date/time"])) {
                                $DepartureDateTime = DateTime::createFromFormat('d-m-Y H:i', $csv["arrival date/time"]);
                                $ReturnDateTime = DateTime::createFromFormat('d-m-Y H:i', $csv["return date/time"]);
                                if (!$DepartureDateTime || !$ReturnDateTime) continue;
                                $DepartureDate = $DepartureDateTime;
                                $ReturnDate = $ReturnDateTime;
                                $dropTime = $DepartureDateTime->format('H:i:s');
                                $returnTime = $ReturnDateTime->format('H:i:s');
                                $Customer = $csv["name"] . " (" . ($csv["mobile"] ?? '') . ")";
                                $Price = (float) $csv["amount paid"];
                                $ProductType = $csv["product name"];
                                $Passenger = $csv["passengers"] ?? 1;
                                $VehicleMake = $csv["make"] ?? '';
                                $Registration = $csv["reg"] ?? '';
                                $AirportTerminal = $csv["arrival terminal"] ?? 'TBC';
                                $InFlight = $csv["out flight"] ?? 'TBC';
                                $OutFlight = $csv["rtn flight"] ?? 'TBC';
                            } else {
                                continue;
                            }

                            if (!$DepartureDate || !$ReturnDate) continue;

                            $check = $conn->query("SELECT ID FROM vehicle_info WHERE BookingRef = '$BookingRef' LIMIT 1");
                            if ($check && $check->num_rows > 0) continue;

                            $stmt = $conn->prepare("INSERT INTO vehicle_info (
                                ProductCode, BookingRef, Customer, EntryDate, EntryTime, ReturnDate, ReturnTime,
                                VehicleMake, RegistrationNo, ProductType, Passenger,
                                AirportTerminal, InFlightNumber, OutFlightNumber, Price, EmailReceivedAt
                            ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

                            $stmt->bind_param("ssssssssssisssds",
                                $ProductType, $BookingRef, $Customer,
                                $DepartureDate->format('Y-m-d'), $dropTime,
                                $ReturnDate->format('Y-m-d'), $returnTime,
                                $VehicleMake, $Registration, $ProductType, $Passenger,
                                $AirportTerminal, $InFlight, $OutFlight, $Price, $emailReceivedDate
                            );

                            $stmt->execute();
                            $stmt->close();
                        }

                        fclose($handle);
                        unlink($tmpFile);
                        $conn->close();
                    }

                    imap_setflag_full($inbox, $email_number, "\\Seen");
                }
            }
        }
    }
    imap_close($inbox);
}
