<?php
ini_set('display_errors', 1);
error_reporting(E_ALL);
ob_start();

// ------------------------
// Database Configuration
// ------------------------
$host = "localhost:3306";
$user = "stanosby_app";
$password = "mD5@NtPdmD5@NtPd";
$dbname = "stanosby_app";


// ------------------------
// Email Configuration
// ------------------------
$emailHost = "{stanstedairportcheapparking.co.uk:993/imap/ssl}";
$emailUser = "booking@stanstedairportcheapparking.co.uk";
$emailPass = "mD5@NtPdmD5@NtPd";

// ------------------------
// Mailbox Folders
// ------------------------
$folders = ["INBOX", "Junk", "Spam"];
$emails = [];

// ------------------------
// Collect Unseen Emails
// ------------------------
foreach ($folders as $folder) {
    $mbox = imap_open($emailHost . $folder, $emailUser, $emailPass);
    if (!$mbox) continue;

    $newEmails = imap_search($mbox, 'UNSEEN');
    if ($newEmails) {
        $emails = array_merge($emails, array_map(function ($id) use ($folder) {
            return ['folder' => $folder, 'id' => $id];
        }, $newEmails));
    }
    imap_close($mbox);
}

if (empty($emails)) {
    echo "📭 No unseen emails found.<br>";
    exit;
}

// ------------------------
// Helper: Parse Body Text
// ------------------------
function parseEmailBody($body) {
    $data = [];

    foreach (explode("\n", $body) as $line) {
        if (strpos($line, ":") !== false) {
            [$key, $value] = explode(":", $line, 2);
            $data[strtolower(trim($key))] = trim($value);
        }
    }

    if (!isset($data['reference code'])) return false;

    $departDT = DateTime::createFromFormat('d-F-Y H:i', $data['departure date/time']);
    $returnDT = DateTime::createFromFormat('d-F-Y H:i', $data['arrival date/time']);
    if (!$departDT || !$returnDT) return false;

    return [
        'ProductCode'       => $data['company name'] ?? 'Unknown',
        'BookingRef'        => $data['reference code'],
        'Customer'          => ($data['name'] ?? '') . ' (' . ($data['contact no'] ?? '') . ')',
        'EntryDate'         => $departDT->format('Y-m-d'),
        'EntryTime'         => $departDT->format('H:i:s'),
        'ReturnDate'        => $returnDT->format('Y-m-d'),
        'ReturnTime'        => $returnDT->format('H:i:s'),
        'VehicleMake'       => $data['make'] ?? '',
        'RegistrationNo'    => $data['registration no.'] ?? '',
        'ProductType'       => $data['company name'] ?? '',
        'Passenger'         => intval($data['passengers'] ?? 1),
        'AirportTerminal'   => $data['departure terminal'] ?? 'TBC',
        'InFlightNumber'    => $data['departure flight no'] ?? 'TBC',
        'OutFlightNumber'   => $data['arrival flight no'] ?? 'TBC',
        'Price'             => floatval(preg_replace('/[^\d.]/', '', $data['amount'] ?? '0')),
    ];
}

// ------------------------
// Process Emails
// ------------------------
foreach ($emails as $emailInfo) {
    $folder = $emailInfo['folder'];
    $email_number = $emailInfo['id'];

    $inbox = imap_open($emailHost . $folder, $emailUser, $emailPass);
    $header = imap_headerinfo($inbox, $email_number);
    $emailReceivedDate = date("Y-m-d H:i:s", strtotime($header->date));
    $structure = imap_fetchstructure($inbox, $email_number);

    // Skip emails with CSV attachment
    $hasCSV = false;
    if (isset($structure->parts)) {
        foreach ($structure->parts as $part) {
            if (!empty($part->ifparameters)) {
                foreach ($part->parameters as $param) {
                    if (strtolower($param->attribute) === "name" && str_ends_with(strtolower($param->value), ".csv")) {
                        $hasCSV = true;
                        break 2;
                    }
                }
            }
        }
    }

    if ($hasCSV) {
        imap_close($inbox);
        continue;
    }

    // Try fetching plain/text body
    $body = imap_fetchbody($inbox, $email_number, "1.1");
    if (trim($body) === '') {
        $body = imap_fetchbody($inbox, $email_number, "1");
    }

    $parsed = parseEmailBody($body);
    if (!$parsed || !$parsed['BookingRef']) {
        echo "⚠️ Could not parse email body for ID $email_number<br>";
        imap_close($inbox);
        continue;
    }

    // DB connection
    $conn = new mysqli($host, $user, $password, $dbname);
    if ($conn->connect_error) {
        echo "❌ DB connection error<br>";
        continue;
    }

    $BookingRef = $conn->real_escape_string($parsed['BookingRef']);
    $check = $conn->query("SELECT ID FROM vehicle_info WHERE BookingRef = '$BookingRef' LIMIT 1");
    if ($check && $check->num_rows > 0) {
        echo "⚠️ BookingRef '$BookingRef' already exists. Skipping.<br>";
        $conn->close();
        imap_close($inbox);
        continue;
    }

    $stmt = $conn->prepare("INSERT INTO vehicle_info (
        ProductCode, BookingRef, Customer, EntryDate, EntryTime, ReturnDate, ReturnTime,
        VehicleMake, RegistrationNo, ProductType, Passenger,
        AirportTerminal, InFlightNumber, OutFlightNumber, Price, EmailReceivedAt
    ) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");

    $stmt->bind_param(
        "ssssssssssisssds",
        $parsed['ProductCode'],
        $parsed['BookingRef'],
        $parsed['Customer'],
        $parsed['EntryDate'],
        $parsed['EntryTime'],
        $parsed['ReturnDate'],
        $parsed['ReturnTime'],
        $parsed['VehicleMake'],
        $parsed['RegistrationNo'],
        $parsed['ProductType'],
        $parsed['Passenger'],
        $parsed['AirportTerminal'],
        $parsed['InFlightNumber'],
        $parsed['OutFlightNumber'],
        $parsed['Price'],
        $emailReceivedDate
    );

    if ($stmt->execute()) {
        echo "✅ Inserted BookingRef: {$parsed['BookingRef']}<br>";
    } else {
        echo "❌ Failed to insert {$parsed['BookingRef']}: {$stmt->error}<br>";
    }

    $stmt->close();
    $conn->close();
    imap_setflag_full($inbox, $email_number, "\\Seen");
    imap_close($inbox);
}
?>
