<?php
session_start();
error_reporting(0);
include('includes/dbconn.php');

if (strlen($_SESSION['vpmsaid']) == 0) {
	header('location:logout.php');
	exit();
} else {
?>

<!DOCTYPE html>
<html>
<head>
	<meta charset="utf-8">
	<title>VPS - Incoming Vehicles</title>
	<meta name="viewport" content="width=device-width, initial-scale=1">
	<link href="css/bootstrap.min.css" rel="stylesheet">
	<link href="css/font-awesome.min.css" rel="stylesheet">
	<link href="css/datatable.css" rel="stylesheet">
	<link href="css/datepicker3.css" rel="stylesheet">
	<link href="css/styles.css" rel="stylesheet">
	<link href="https://fonts.googleapis.com/css?family=Montserrat:300,300i,400,400i,500,500i,600,600i,700,700i" rel="stylesheet">

	<style>
		.table-responsive-horizontal {
			overflow-x: auto;
		}
		table th, table td {
			white-space: nowrap;
		}
	</style>
</head>
<body>

<?php include 'includes/navigation.php'; ?>
<?php $page = "in-vehicle"; include 'includes/sidebar.php'; ?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
	<div class="row">
		<ol class="breadcrumb">
			<li><a href="dashboard.php"><em class="fa fa-home"></em></a></li>
			<li class="active">Incoming Vehicle Management</li>
		</ol>
	</div>

	<div class="row">
		<div class="col-lg-12">
			<h3 class="page-header">Incoming Bookings</h3>
		</div>
	</div>

	<div class="row">
		<div class="col-lg-12">
			<div class="panel panel-default">
				<div class="panel-heading">All Incoming Vehicle Bookings</div>
				<div class="panel-body">
					<div class="table-responsive-horizontal">
						<table id="example" class="table table-striped table-hover table-bordered" style="width: 100%;">
							<thead>
								<tr>
									<th>#</th>
									<th>Product Code</th>
									<th>Booking Ref</th>
									<th>Customer</th>
									<th>Entry Date</th>
									<th>Entry Time</th>
									<th>Return Date</th>
									<th>Return Time</th>
									<th>Vehicle Make</th>
									<th>Registration No.</th>
									<th>Product Type</th>
									<th>Passenger</th>
									<th>Airport Terminal</th>
									<th>In Flight</th>
									<th>Out Flight</th>
									<th>Price</th>
									<th>Action</th>
								</tr>
							</thead>
							<tbody>
								<?php
								$query = mysqli_query($con, "SELECT * FROM vehicle_info ORDER BY EntryDate DESC, EntryTime DESC");
								$cnt = 1;
								while ($row = mysqli_fetch_array($query)) {
								?>
								<tr>
									<td><?php echo $cnt++; ?></td>
									<td><?php echo htmlspecialchars($row['ProductCode']); ?></td>
									<td><?php echo htmlspecialchars($row['BookingRef']); ?></td>
									<td><?php echo htmlspecialchars($row['Customer']); ?></td>
									<td><?php echo htmlspecialchars($row['EntryDate']); ?></td>
									<td><?php echo htmlspecialchars($row['EntryTime']); ?></td>
									<td><?php echo htmlspecialchars($row['ReturnDate']); ?></td>
									<td><?php echo htmlspecialchars($row['ReturnTime']); ?></td>
									<td><?php echo htmlspecialchars($row['VehicleMake']); ?></td>
									<td><?php echo htmlspecialchars($row['RegistrationNo']); ?></td>
									<td><?php echo htmlspecialchars($row['ProductType']); ?></td>
									<td><?php echo htmlspecialchars($row['Passenger']); ?></td>
									<td><?php echo htmlspecialchars($row['AirportTerminal']); ?></td>
									<td><?php echo htmlspecialchars($row['InFlightNumber']); ?></td>
									<td><?php echo htmlspecialchars($row['OutFlightNumber']); ?></td>
									<td>£<?php echo number_format($row['Price'], 2); ?></td>
									<td>
										<a href="update-incomingdetail.php?updateid=<?php echo $row['ID']; ?>">
											<button type="button" class="btn btn-sm btn-danger">Take Action</button>
										</a>
									</td>
								</tr>
								<?php } ?>
							</tbody>
						</table>
					</div> <!-- /.table-responsive -->
				</div> <!-- /.panel-body -->
			</div>
		</div>
	</div>

	<?php include 'includes/footer.php'; ?>
</div>

<!-- Scripts -->
<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/chart.min.js"></script>
<script src="js/chart-data.js"></script>
<script src="js/easypiechart.js"></script>
<script src="js/easypiechart-data.js"></script>
<script src="js/jquery.dataTables.min.js"></script>
<script src="js/dataTables.bootstrap4.min.js"></script>
<script src="js/bootstrap-datepicker.js"></script>
<script src="js/custom.js"></script>

<script>
	$(document).ready(function () {
		$('#example').DataTable({
			scrollX: true
		});
	});
</script>

</body>
</html>

<?php } ?>
