<?php
session_start();
error_reporting(0);
include('includes/dbconn.php');

if (strlen($_SESSION['vpmsaid']) == 0) {
    header('location:logout.php');
    exit();
}

$filter = $_GET['filter'] ?? 'departures'; // default to departures
$fromDate = $_GET['fromDate'] ?? '';
$toDate = $_GET['toDate'] ?? '';
$today = date('Y-m-d');

if (!empty($fromDate) && !empty($toDate)) {
    switch ($filter) {
        case 'bookings':
            $query = "SELECT * FROM vehicle_info WHERE DATE(EmailReceivedAt) BETWEEN '$fromDate' AND '$toDate' ORDER BY EmailReceivedAt DESC";
            break;
        case 'departures':
            $query = "SELECT * FROM vehicle_info WHERE EntryDate BETWEEN '$fromDate' AND '$toDate' ORDER BY EmailReceivedAt DESC";
            break;
        case 'returns':
            $query = "SELECT * FROM vehicle_info WHERE ReturnDate BETWEEN '$fromDate' AND '$toDate' ORDER BY EmailReceivedAt DESC";
            break;
        case 'all':
        default:
            $query = "SELECT * FROM vehicle_info ORDER BY EmailReceivedAt DESC";
            break;
    }
} else {
    switch ($filter) {
        case 'bookings':
            $query = "SELECT * FROM vehicle_info WHERE DATE(EmailReceivedAt) = '$today' ORDER BY EmailReceivedAt DESC";
            break;
        case 'departures':
            $query = "SELECT * FROM vehicle_info WHERE EntryDate = '$today' ORDER BY EmailReceivedAt DESC";
            break;
        case 'returns':
            $query = "SELECT * FROM vehicle_info WHERE ReturnDate = '$today' ORDER BY EmailReceivedAt DESC";
            break;
        case 'all':
        default:
            $query = "SELECT * FROM vehicle_info ORDER BY EmailReceivedAt DESC";
            break;
    }
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>All Bookings - VPS</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSS -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/datatable.css">
    <link rel="stylesheet" href="https://cdn.datatables.net/1.13.6/css/dataTables.bootstrap4.min.css">
    <link rel="stylesheet" href="css/datepicker3.css">
    <link rel="stylesheet" href="css/styles.css">

    <style>
        .export-buttons {
            display: flex;
            gap: 10px;
        }
        .table-scroll-container {
            width: 100%;
            overflow-x: auto;
        }
        table.dataTable thead th {
            white-space: nowrap;
        }
        .action-header {
            display: flex;
            justify-content: space-between;
            align-items: center;
        }
        .filter-buttons {
            margin-bottom: 15px;
        }
        @media (max-width: 768px) {
            .date-range-form .form-group {
                margin-bottom: 10px;
            }
        }
    </style>
</head>
<body>

<?php include 'includes/navigation.php'; ?>
<?php $page = "all-vehicles"; include 'includes/sidebar.php'; ?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">
    <div class="row">
        <ol class="breadcrumb">
            <li><a href="out-vehicles.php"><em class="fa fa-home"></em></a></li>
            <li class="active">All Vehicle Bookings</li>
        </ol>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="page-header action-header">
                <h3>All Bookings</h3>
                <div class="export-buttons">
                    <button class="btn btn-sm btn-warning" onclick="refreshBookings(this)">
                        <i class="fa fa-refresh"></i> Refresh Bookings
                    </button>
                    <button class="btn btn-sm btn-success" onclick="exportTableToCSV()">CSV</button>
                    <button class="btn btn-sm btn-primary" onclick="exportTableToXLSX()">XLSX</button>
                </div>
            </div>
        </div>
    </div>

    <div class="row filter-buttons text-center">
        <div class="col-lg-12">
            <a href="?filter=departures" class="btn btn-outline-primary">Departures</a>
            <a href="?filter=bookings" class="btn btn-outline-primary">Bookings</a>
            <a href="?filter=returns" class="btn btn-outline-primary">Return</a>
            <a href="?filter=all" class="btn btn-outline-primary">All</a>
        </div>
    </div>

    <div class="row text-center mb-3">
        <div class="col-lg-12">
            <form class="form-inline date-range-form" method="GET" style="display: flex; flex-wrap: wrap; justify-content: center; gap: 10px;">
                <input type="hidden" name="filter" value="<?php echo htmlspecialchars($filter); ?>">
                <div class="form-group">
                    <label for="fromDate">From:</label>
                    <input type="date" name="fromDate" id="fromDate" value="<?php echo htmlspecialchars($fromDate); ?>" class="form-control">
                </div>
                <div class="form-group">
                    <label for="toDate">To:</label>
                    <input type="date" name="toDate" id="toDate" value="<?php echo htmlspecialchars($toDate); ?>" class="form-control">
                </div>
                <button type="submit" class="btn btn-info">Filter</button>
            </form>
        </div>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <div class="panel panel-default">
                <div class="panel-body table-scroll-container">
                    <table id="vehiclesTable" class="table table-bordered table-striped table-hover" style="width:100%">
                        <thead class="thead-dark">
                            <tr>
                                <th>#</th>
                                <th>Product Code</th>
                                <th>Booking Ref</th>
                                <th>Customer</th>
                                <th>Entry Date</th>
                                <th>Entry Time</th>
                                <th>Return Date</th>
                                <th>Return Time</th>
                                <th>Vehicle Make</th>
                                <th>Registration No.</th>
                                <th>Product Type</th>
                                <th>Passenger</th>
                                <th>Airport Terminal</th>
                                <th>IN Flight</th>
                                <th>OUT Flight</th>
                                <th>Price</th>
                                <th>Actions</th>
                            </tr>
                        </thead>
                        <tbody>
                        <?php
                        $ret = mysqli_query($con, $query);
                        $cnt = 1;
                        while ($row = mysqli_fetch_array($ret)) {
                        ?>
                            <tr>
                                <td><?php echo $cnt++; ?></td>
                                <td><?php echo $row['ProductCode'] ?? '—'; ?></td>
                                <td><?php echo $row['BookingRef'] ?? '—'; ?></td>
                                <td><?php echo $row['Customer'] ?? '—'; ?></td>
                                <td><?php echo $row['EntryDate'] ?? '—'; ?></td>
                                <td><?php echo $row['EntryTime'] ?? '—'; ?></td>
                                <td><?php echo $row['ReturnDate'] ?? '—'; ?></td>
                                <td><?php echo $row['ReturnTime'] ?? '—'; ?></td>
                                <td><?php echo $row['VehicleMake'] ?? '—'; ?></td>
                                <td><?php echo $row['RegistrationNo'] ?? '—'; ?></td>
                                <td><?php echo $row['ProductType'] ?? '—'; ?></td>
                                <td><?php echo $row['Passenger'] ?? '—'; ?></td>
                                <td><?php echo $row['AirportTerminal'] ?? '—'; ?></td>
                                <td><?php echo $row['InFlightNumber'] ?? '—'; ?></td>
                                <td><?php echo $row['OutFlightNumber'] ?? '—'; ?></td>
                                <td>£<?php echo number_format($row['Price'] ?? 0, 2); ?></td>
                                <td>
                                    <a href="outgoing-detail.php?updateid=<?php echo $row['ID']; ?>" class="btn btn-sm btn-info">View</a>
                                    <a href="print-receipt.php?vid=<?php echo $row['ID']; ?>" class="btn btn-sm btn-warning"><i class="fa fa-print"></i></a>
                                </td>
                            </tr>
                        <?php } ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php'; ?>
</div>

<!-- Scripts -->
<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/bootstrap-datepicker.js"></script>
<script src="js/custom.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/jquery.dataTables.min.js"></script>
<script src="https://cdn.datatables.net/1.13.6/js/dataTables.bootstrap4.min.js"></script>
<script src="https://cdnjs.cloudflare.com/ajax/libs/xlsx/0.18.5/xlsx.full.min.js"></script>

<script>
    $(document).ready(function () {
        $('#vehiclesTable').DataTable({
            scrollX: true,
            autoWidth: false,
            language: {
                searchPlaceholder: "Search bookings..."
            }
        });
    });

    function exportTableToCSV() {
        const table = document.getElementById("vehiclesTable");
        let csv = [];
        for (let row of table.rows) {
            let cols = [...row.cells].map(cell => `"${cell.innerText}"`);
            csv.push(cols.join(","));
        }
        const csvString = csv.join("\n");
        const blob = new Blob([csvString], { type: "text/csv" });
        const url = window.URL.createObjectURL(blob);
        const a = document.createElement("a");
        a.setAttribute("hidden", "");
        a.setAttribute("href", url);
        a.setAttribute("download", "all_vehicle_bookings.csv");
        document.body.appendChild(a);
        a.click();
        document.body.removeChild(a);
    }

    function exportTableToXLSX() {
        const table = document.getElementById("vehiclesTable");
        const wb = XLSX.utils.book_new();
        const ws = XLSX.utils.table_to_sheet(table);
        XLSX.utils.book_append_sheet(wb, ws, "Bookings");
        XLSX.writeFile(wb, "all_vehicle_bookings.xlsx");
    }

    function refreshBookings(btn) {
        btn.innerHTML = '<i class="fa fa-spinner fa-spin"></i> Refreshing...';
        btn.disabled = true;

        fetch('fetch_and_insert_email.php')
            .then(() => {
                location.reload();
            })
            .catch(error => {
                console.error("❌ Error while refreshing:", error);
                location.reload();
            });
    }
</script>

</body>
</html>
