<?php
session_start();
error_reporting(0);
include('includes/dbconn.php');

if (strlen($_SESSION['vpmsaid']) == 0) {
    header('location:logout.php');
    exit();
}

$vehicleData = null;
$msg = '';

if (isset($_GET['updateid'])) {
    $cid = intval($_GET['updateid']);
    $ret = mysqli_query($con, "SELECT * FROM vehicle_info WHERE ID = '$cid'");

    if ($ret && mysqli_num_rows($ret) > 0) {
        $vehicleData = mysqli_fetch_assoc($ret);
    } else {
        $msg = "Vehicle record not found.";
    }
} else {
    $msg = "No vehicle ID provided.";
}
?>

<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
    <title>View Vehicle Info - VPS</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">

    <!-- CSS -->
    <link rel="stylesheet" href="css/bootstrap.min.css">
    <link rel="stylesheet" href="css/font-awesome.min.css">
    <link rel="stylesheet" href="css/styles.css">
    <link rel="stylesheet" href="css/datatable.css">

    <!-- Fix for readonly input colors -->
    <style>
        input[readonly], textarea[readonly] {
            background-color: #fff !important;
            color: #000 !important;
            border: 1px solid #ccc;
        }
    </style>
</head>
<body>

<?php include 'includes/navigation.php'; ?>
<?php $page = "out-vehicle"; include 'includes/sidebar.php'; ?>

<div class="col-sm-9 col-sm-offset-3 col-lg-10 col-lg-offset-2 main">

    <div class="row">
        <ol class="breadcrumb">
            <li><a href="out-vehicles.php"><em class="fa fa-home"></em></a></li>
            <li class="active">View Vehicle Info</li>
        </ol>
    </div>

    <div class="row">
        <div class="col-lg-12">
            <h2 class="page-header">Vehicle Booking Details</h2>
        </div>
    </div>

    <?php if ($msg): ?>
        <div class="alert alert-danger"><?php echo $msg; ?></div>
    <?php endif; ?>

    <?php if ($vehicleData): ?>
        <div class="row">
            <div class="col-lg-8">
                <div class="panel panel-default">
                    <div class="panel-heading">Vehicle Details</div>
                    <div class="panel-body">
                        <form>
                            <?php
                            function field($label, $value) {
                                return '
                                    <div class="form-group">
                                        <label>' . $label . '</label>
                                        <input type="text" class="form-control" value="' . htmlspecialchars($value) . '" readonly>
                                    </div>
                                ';
                            }

                            echo field("Product Code", $vehicleData['ProductCode']);
                            echo field("Booking Ref", $vehicleData['BookingRef']);
                            echo field("Customer", $vehicleData['Customer']);
                            echo field("Registration No.", $vehicleData['RegistrationNo']);
                            echo field("Vehicle Make", $vehicleData['VehicleMake']);
                            echo field("Entry Date & Time", $vehicleData['EntryDate'] . ' ' . $vehicleData['EntryTime']);
                            echo field("Return Date & Time", $vehicleData['ReturnDate'] . ' ' . $vehicleData['ReturnTime']);
                            echo field("Passenger", $vehicleData['Passenger']);
                            echo field("Product Type", $vehicleData['ProductType']);
                            echo field("Airport Terminal", $vehicleData['AirportTerminal']);
                            echo field("In Flight Number", $vehicleData['InFlightNumber']);
                            echo field("Out Flight Number", $vehicleData['OutFlightNumber']);
                            echo field("Parking Number", $vehicleData['ParkingNumber']);
                            echo field("Status", $vehicleData['Status']);
                            echo field("Price", '£' . number_format($vehicleData['Price'], 2));
                            ?>

                            <div class="form-group">
                                <label>Remarks</label>
                                <textarea class="form-control" rows="3" readonly><?php echo htmlspecialchars($vehicleData['Remark']); ?></textarea>
                            </div>

                        </form>
                    </div>
                </div>
            </div>
        </div>
    <?php endif; ?>

    <?php include 'includes/footer.php'; ?>
</div>

<!-- Scripts -->
<script src="js/jquery-1.11.1.min.js"></script>
<script src="js/bootstrap.min.js"></script>
<script src="js/custom.js"></script>

</body>
</html>
