<?php
session_start();
error_reporting(0);
include('includes/dbconn.php');

if (!isset($_SESSION['vpmsaid']) || strlen($_SESSION['vpmsaid']) == 0) {
    header('location:logout.php');
    exit();
}

if (!isset($_GET['vid'])) {
    die("Error: Missing vehicle ID.");
}

$vid = intval($_GET['vid']);
$ret = mysqli_query($con, "SELECT * FROM vehicle_info WHERE ID = '$vid' LIMIT 1");

if (!$ret || mysqli_num_rows($ret) === 0) {
    die("Error: Vehicle not found.");
}

$row = mysqli_fetch_assoc($ret);
?>

<!DOCTYPE html>
<html>
<head>
    <meta charset="utf-8">
    <title>Booking Confirmation - VPS</title>
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <link href="css/bootstrap.min.css" rel="stylesheet">
    <link href="css/font-awesome.min.css" rel="stylesheet">
</head>
<body>

<div class="container mt-5">
    <a href="out-vehicles.php" class="btn btn-primary mb-4">← Back</a>

    <div id="receipt">
        <table class="table table-bordered">
            <thead>
                <tr>
                    <th colspan="4" class="text-center" style="font-size: 22px;">Booking Confirmation</th>
                </tr>
            </thead>

            <tbody>
                <tr>
                    <th>Booking Reference</th>
                    <td colspan="3"><?= htmlspecialchars($row['BookingRef'] ?? '—') ?></td>
                </tr>

                <tr>
                    <th>Dates</th>
                    <td colspan="3">
                        <?= htmlspecialchars($row['EntryDate'] ?? '—') ?> <?= htmlspecialchars($row['EntryTime'] ?? '') ?>
                        to
                        <?= htmlspecialchars($row['ReturnDate'] ?? '—') ?> <?= htmlspecialchars($row['ReturnTime'] ?? '') ?>
                    </td>
                </tr>

                <tr>
                    <th>Customer Name</th>
                    <td><?= htmlspecialchars($row['Customer'] ?? '—') ?></td>
                    <th>Phone Number</th>
                    <td><?= htmlspecialchars($row['OwnerContactNumber'] ?? '—') ?></td>
                </tr>

                <tr>
                    <th>Vehicle Registration</th>
                    <td><?= htmlspecialchars($row['RegistrationNo'] ?? '—') ?></td>
                    <th>Vehicle</th>
                    <td><?= htmlspecialchars($row['VehicleMake'] ?? '—') ?></td>
                </tr>

                <tr>
                    <th>Airport Terminal</th>
                    <td><?= htmlspecialchars($row['AirportTerminal'] ?? '—') ?></td>
                    <th>Return Flight No.</th>
                    <td><?= htmlspecialchars($row['OutFlightNumber'] ?? '—') ?></td>
                </tr>

                <tr>
                    <th>Created On</th>
                    <td colspan="3"><?= date("d-M-Y H:i:s") ?></td>
                </tr>

                <tr>
                    <th>Car Mileage</th>
                    <td colspan="3">______________________</td>
                </tr>

                <tr>
                    <th>Addons</th>
                    <td colspan="3">______________________</td>
                </tr>

                <tr>
                    <th>Valuables Left In Car:</th>
                    <td colspan="3">
                        <label><input type="checkbox"> SatNav</label> &nbsp;
                        <label><input type="checkbox"> Mobile</label> &nbsp;
                        <label><input type="checkbox"> Sunglasses</label> &nbsp;
                        <label><input type="checkbox"> Other</label>
                    </td>
                </tr>

                <tr>
                    <th>Comments</th>
                    <td colspan="3"><?= htmlspecialchars($row['Remark'] ?? '—') ?></td>
                </tr>

                <tr>
                    <th>Total Price</th>
                    <td colspan="3">£ <?= is_numeric($row['Price']) ? number_format($row['Price'], 2) : '0.00' ?></td>
                </tr>

                <tr>
                    <th colspan="4" class="text-center bg-light">Customer Vehicle Delivery</th>
                </tr>
                <tr>
                    <td colspan="2">Signed By: _____________________</td>
                    <td colspan="2">Driver: _____________________</td>
                </tr>

                <tr>
                    <th colspan="4" class="text-center bg-light">Customer Vehicle Collection</th>
                </tr>
                <tr>
                    <td colspan="2">Signed By: _____________________</td>
                    <td colspan="2">Driver: _____________________</td>
                </tr>

                <tr>
                    <td colspan="4" class="text-center small">
                        *By booking online and signing this form, I agree to the terms and conditions.
                    </td>
                </tr>

                <tr>
                    <td colspan="4" class="text-center">
                        <i class="fa fa-print fa-3x mt-3" style="cursor:pointer;" onclick="printDiv('receipt')"></i>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>
</div>

<script>
function printDiv(divId) {
    const content = document.getElementById(divId).innerHTML;
    const printWindow = window.open('', '', 'width=800,height=700');
    printWindow.document.write('<html><head><title>Print Receipt</title>');
    printWindow.document.write('<link rel="stylesheet" href="css/bootstrap.min.css">');
    printWindow.document.write('</head><body>');
    printWindow.document.write(content);
    printWindow.document.write('</body></html>');
    printWindow.document.close();
    printWindow.focus();
    printWindow.print();
    printWindow.close();
}
</script>

</body>
</html>
