<?php
// Load PHPMailer via Composer
use PHPMailer\PHPMailer\PHPMailer;
use PHPMailer\PHPMailer\Exception;

require 'vendor/autoload.php';
header('Content-Type: application/json');

// Get bookingRef from request
$input = json_decode(file_get_contents('php://input'), true);
$bookingRef = $input['bookingRef'] ?? '';

if (empty($bookingRef)) {
    http_response_code(400);
    echo json_encode(['success' => false, 'message' => 'Missing bookingRef']);
    exit;
}

// ✅ LIVE DATABASE CREDENTIALS
$servername = "localhost:3306";
$username = "stanosby_app";
$password = "mD5@NtPdmD5@NtPd";
$dbname = "stanosby_app";

// Connect to database
$conn = new mysqli($servername, $username, $password, $dbname);
if ($conn->connect_error) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'DB connection failed']);
    exit;
}

// Step 1: Update status to 'Paid'
$stmt = $conn->prepare("UPDATE vehicle_info SET Status = 'Paid' WHERE BookingRef = ?");
$stmt->bind_param("s", $bookingRef);
if (!$stmt->execute()) {
    http_response_code(500);
    echo json_encode(['success' => false, 'message' => 'Failed to update booking status']);
    exit;
}
$stmt->close();

// Step 2: Fetch booking details
$result = $conn->query("SELECT * FROM vehicle_info WHERE BookingRef = '$bookingRef'");
if (!$result || $result->num_rows === 0) {
    echo json_encode(['success' => true, 'message' => 'Booking updated, but no details found']);
    exit;
}

$booking = $result->fetch_assoc();
$conn->close();

// ✅ Change to real customer email if stored in DB
$toEmail = $booking['Email'] ?? 'customer@example.com';

// Email content
$subject = "Booking Confirmation - Ref: {$bookingRef}";
$body = "Dear {$booking['Customer']},\n\n"
      . "Thank you for your booking. Your payment has been received.\n\n"
      . "📄 Booking Details:\n"
      . "Booking Reference: {$booking['BookingRef']}\n"
      . "Vehicle: {$booking['VehicleMake']} ({$booking['RegistrationNo']})\n"
      . "Entry Date: {$booking['EntryDate']} at {$booking['EntryTime']}\n"
      . "Return Date: {$booking['ReturnDate']} at {$booking['ReturnTime']}\n"
      . "Terminal: {$booking['AirportTerminal']}\n"
      . "Total Price: £{$booking['Price']}\n\n"
      . "If you have any questions, contact us at support@stanstedairportcheapparking.co.uk\n\n"
      . "Regards,\n"
      . "Stansted Airport Parking";

// Send email with PHPMailer
$mail = new PHPMailer(true);
try {
    $mail->isSMTP();
    $mail->Host = 'stanstedairportcheapparking.co.uk';
    $mail->SMTPAuth = true;
    $mail->Username = 'booking@stanstedairportcheapparking.co.uk';
    $mail->Password = 'mD5@NtPdmD5@NtPd';
    $mail->SMTPSecure = PHPMailer::ENCRYPTION_SMTPS;
    $mail->Port = 465;

    $mail->setFrom('booking@stanstedairportcheapparking.co.uk', 'Stansted Airport Parking');
    $mail->addAddress($toEmail);

    $mail->Subject = $subject;
    $mail->Body    = $body;

    $mail->send();
    echo json_encode(['success' => true, 'message' => 'Booking updated & confirmation email sent']);
} catch (Exception $e) {
    echo json_encode(['success' => true, 'message' => 'Booking updated, but email failed: ' . $mail->ErrorInfo]);
}
